<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-people me-2"></i>Kelola Organisasi
    </h2>
    <a href="<?= base_url('admin/organizations/create') ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle me-1"></i>Tambah Organisasi
    </a>
</div>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i><?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i><?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Search and Filter Section -->
<div class="admin-card">
    <form method="GET" action="<?= base_url('admin/organizations') ?>" class="row g-3">
        <div class="col-md-3">
            <label for="search" class="form-label">Cari Organisasi</label>
            <input type="text" class="form-control" id="search" name="search" 
                   value="<?= esc($search) ?>" placeholder="Cari nama organisasi...">
        </div>
        <div class="col-md-2">
            <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
            <input type="number" class="form-control" id="tahun_mulai" name="tahun_mulai" 
                   value="<?= esc($filter['tahun_mulai']) ?>" placeholder="Tahun mulai...">
        </div>
        <div class="col-md-2">
            <label for="tahun_selesai" class="form-label">Tahun Selesai</label>
            <input type="number" class="form-control" id="tahun_selesai" name="tahun_selesai" 
                   value="<?= esc($filter['tahun_selesai']) ?>" placeholder="Tahun selesai...">
        </div>
        <div class="col-md-2">
            <label for="sort" class="form-label">Sort By</label>
            <select class="form-select" id="sort" name="sort">
                <option value="urutan" <?= $sort === 'urutan' ? 'selected' : '' ?>>Urutan</option>
                <option value="nama_organisasi" <?= $sort === 'nama_organisasi' ? 'selected' : '' ?>>Nama Organisasi</option>
                <option value="tahun_mulai" <?= $sort === 'tahun_mulai' ? 'selected' : '' ?>>Tahun Mulai</option>
            </select>
        </div>
        <div class="col-md-1">
            <label for="order" class="form-label">Order</label>
            <select class="form-select" id="order" name="order">
                <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>ASC</option>
                <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>DESC</option>
            </select>
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="bi bi-funnel"></i>
            </button>
        </div>
    </form>
</div>

<!-- Organizations Table -->
<div class="admin-card">
    <?php if (empty($organizations)): ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle me-2"></i>Tidak ada organisasi yang ditemukan.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Urutan</th>
                        <th>Nama Organisasi</th>
                        <th>Jabatan</th>
                        <th>Tahun</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = ($pager->getCurrentPage() - 1) * 10 + 1; ?>
                    <?php foreach ($organizations as $org): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= esc($org['urutan']) ?></td>
                            <td><?= esc($org['nama_organisasi']) ?></td>
                            <td><?= esc($org['jabatan'] ?? '-') ?></td>
                            <td>
                                <?php if ($org['tahun_mulai'] && $org['tahun_selesai']): ?>
                                    <?= esc($org['tahun_mulai']) ?> - <?= esc($org['tahun_selesai']) ?>
                                <?php elseif ($org['tahun_mulai']): ?>
                                    <?= esc($org['tahun_mulai']) ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?= base_url('admin/organizations/edit/' . $org['id']) ?>" 
                                   class="btn btn-sm btn-warning btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= base_url('admin/organizations/delete/' . $org['id']) ?>" 
                                   class="btn btn-sm btn-danger btn-action"
                                   onclick="return confirm('Yakin ingin menghapus organisasi ini?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($pager->getLastPage() > 1): ?>
            <nav aria-label="Page navigation" class="mt-4">
                <ul class="pagination">
                    <?php if ($pager->getCurrentPage() > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/organizations?page=' . ($pager->getCurrentPage() - 1) . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $pager->getLastPage(); $i++): ?>
                        <li class="page-item <?= $i == $pager->getCurrentPage() ? 'active' : '' ?>">
                            <a class="page-link" href="<?= base_url('admin/organizations?page=' . $i . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                Part <?= $i ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                    
                    <?php if ($pager->getCurrentPage() < $pager->getLastPage()): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/organizations?page=' . ($pager->getCurrentPage() + 1) . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>


